<?php
defined('BAIFU_PATH') or exit('Access Denied');
/**
 * 演示增删改查
 */
class DefaultController extends Controller {
	protected $name = 'page';
	function _init() {
		parent::_init();
		$this->service = Service::instance($this->name);
		$this->pk = $this->service->getPk();
		$this->model = Model::instance($this->name);
		$this->seo = array(
		'title'=>'演示增删改查----百福PHP开发框架',
		'keywords'=>'baifu类库,PHP架构',
		'description'=>'百福框架基本使用演示',
		);
	}
	
	public function index() {
		$page=intval($_REQUEST['page']);
		$pagesize = 10;
		$where = array();
		$count = $this->service->where ( $where )->count ( 'id' );
		if ($count > 0) {
			$pager = new Pager ( $count, $page, $pagesize );
			$this->pager = $pager;
			$list = $this->service->where ( $where )->order ( 'id desc' )->limit ( $pager->offset . ',' . $pager->pagesize )->select ();
			
		}
		$this->list = $list;
		$this->seo = array(
		'title'=>'首页',
		'keywords'=>'baifu,PHP架构',
		'description'=>'百福框架基本使用演示',
		);
		$this->view ();
	}
	public function add() {
		if(IS_POST){
			$data = $this->model->getInput ();
			if (false === $data) {
				$this->error ( $this->model->getError () );
			}
			$data['addtime'] = NOW;
			//$data['edittime'] = NOW;
			$this->service->insert ( $data );
			$this->success ('操作成功!');
		}else{
			$this->data = $_REQUEST;
		}
		$this->view ();
	}
	public function edit() {
		$this->_getOne();
		if(IS_POST){
			$data = $this->model->getInput ();
			if (false === $data) {
				$this->error ( $this->model->getError () );
			}
			//$data['edittime'] = NOW;
			$this->service->update ($data);
			$this->success ('操作成功!');
		}else{
		}
		$this->view ();
	}

	public function delete() {
		$id = $_REQUEST [$this->pk];
		if(!$id) $this->error("请选择操作项");
		$ids = is_array ( $id ) ? $id : array ($id );
		foreach ($ids as $id){
			$item = $this->_getOne ( $id );
			if (! empty ( $item )) {
				$this->service->delete ($item[$this->pk]);
			}else{
				$this->error ( '非法操作' );
			}
		}
		$this->success ('删除成功！');
	}
	public function show() {
		$this->_getOne();
		$this->view ();
	}
	function _getOne($id = '') {
		$id = empty ( $id ) ? $_REQUEST [$this->pk] : $id;
		if (is_array ( $id )) {
			$data = $this->service->where ( $id )->getOne ();
		} else {
			$data = $this->service->getOne ( intval ( $id ) );
		}
		if (! $data)
			$this->error ( '数据不存在' );
		
		return $this->data = $data;
	}
	/**
	 * 唯一验证
	 */
	public function unique(){
		$model=$_REQUEST['_model'];
		if(empty($model)||!class_exists($model.'Model')){
			exit('false');
		}
		$map=$_REQUEST[$model];
		$service=Service::instance($model);
		$pk=$service->getPk();
		if(isset($map[$pk])){
			$map[$pk] = array('neq',$map[$pk]);
		}
		if($service->where($map)->getOne())  exit('false');
		exit('true');
	}
	/**
	 * 保存上传的文件
	 */
	public function upload() {
		if (empty ( $_FILES )) {
			$this->error('没有接收到文件');
		}
		require_once 'upload/upload.class.php';
		Baifu::set('isajax',true);
		$type = $_REQUEST ['type'];
		if (! in_array ( $type, array ('image', 'flash', 'file', 'media' ) )) {
			$type = 'default';
		}
		$config = array ();
		$upload = new Upload($type,$config);
		$isremote=$_REQUEST['isremote']?true:false;
		if($isremote){
			$file=$_REQUEST['file'];
		}else{
			$file=$_FILES;
		}
		$filepath = array ();
		if (! $upload->save ($file,$isremote)) {
			$this->error ( $upload->getError() );
		} else {
			$uploadList = $upload->getUploadFiles ();
			foreach ( $uploadList as $key => $file ) {
				$filepath [] = array(
					'name'=>$file['name'],
					'filepath'=>UrlFormat($file ['path']),
				);
				$_SESSION['uploads'][]=$file ['path'];
			}
			
		}
		
		$data = array ();
		$data ['status'] = true;
		$data ['message'] = '';
		$data ['data'] = $filepath;
		$this->ajax ( $data );
	
	}
}
?>