<?php
/**
 * 插件抽象类
 */
abstract class Plugin {
	/**
	 * 当前插件名称
	 */
	protected $name = '';

    /**
	 * 当前插件设置
	 */
	protected $config = array();
/**
     * 架构函数
     * @access public
     */
    public function __construct() {

    }
/**
     * 设置数据对象的值
     * @access public
     * @param string $name 名称
     * @param mixed $value 值
     * @return void
     */
    public function __set($name,$value) {
        // 设置数据对象属性
        $this->config[$name]  =   $value;
    }

    /**
     * 获取数据对象的值
     * @access public
     * @param string $name 名称
     * @return mixed
     */
    public function __get($name) {
        return isset($this->config[$name])?$this->config[$name]:null;
    }

    /**
     * 检测数据对象的值
     * @access public
     * @param string $name 名称
     * @return boolean
     */
    public function __isset($name) {
        return isset($this->config[$name]);
    }

    /**
     * 销毁数据对象的值
     * @access public
     * @param string $name 名称
     * @return void
     */
    public function __unset($name) {
        unset($this->config[$name]);
    }

	public function install() {
		return true;
	}

	public function uninstall() {
		return true;
	}
    
}