<?php
/**
 * 模型基类
 */
class Model {
	/**
	 * 模型配置
	 */
	protected $config = array ();
	/**
	 * 模型数据数组
	 */
	public $data = array ();
	/**
	 * 即将入库的处理后表单数据数组
	 */
	public $input = array ();
	/**
	 * 默认模型名称
	 */
	public $name = '';
	/**
	 * 当前模型名称
	 */
	protected $currentModel = '';
	/**
	 * 字段定义
	 */
	public $fields = array ();
	/**
	 * 正则表达式
	 */
	protected $rules = array ('required' => '/.+/', 'zip' => '/^\d{6}$/', 'phone' => '/^(13|18)\d{9}$|15[0189]{1}[0-9]{8}$/', 'telephone' => '/^(([0\+]\d{2,3}-)?(0\d{2,3})-)?(\d{7,8})(-(\d{3,}))?$/', 'email' => '/^\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$/', 'url' => '/^http(s?):\/\/(?:[A-za-z0-9-]+\.)+[A-za-z]{2,4}(?:[\/\?#][\/=\?%\-&~`@[\]\':+!\.#\w]*)?$/', 'currency' => '/^\d+(\.\d+)?$/', 'number' => '/^[-\+]?\d+$/', 'digits' => '/^\d+$/', 'double' => '/^[-\+]?\d+(\.\d+)?$/' );
	/**
	 * 错误信息
	 */
	protected $error = '';
	/**
	 * 列表过滤器
	 */
	public $filter = array ();
	/**
	 * 列表搜索条件
	 */
	public $search = array ();
	/**
	 * 列表分页
	 */
	public $pager = '';
	
	/**
	 * HTML表单定义
	 */
	public $html = array ();
	/**
	 * 架构函数
	 */
	public function __construct() {
	
	}
	/**
	 * 取得类实例
	 * @static
	 * @access public
	 * @return Model 返回Model实例
	 */
	public static function instance($name = '') {
		$args = func_get_args ();
		static $_instance = array ();
		$identify = Guid ( $args );
		if (! isset ( $_instance [$identify] )) {
			$name = $args [0];
			$data = $args [1] ? $args [1] : array ();
			$model = $args [2];
			if (empty ( $model )) {
				$class = $name . 'Model';
				if (class_exists ( $class )) {
					$model = new $class ();
				}
			} elseif (is_string ( $model )) {
				$class = $model;
				if (class_exists ( $class )) {
					$model = new $class ();
				}
			}
			
			if (! is_object ( $model )) {
				$model = new Model ();
			}
			if ($model->getModelName () == '') {
				$model->name = strtolower ( $name );
			}
			$model->setData ( $data );
			$_instance [$identify] = $model;
		}
		return $_instance [$identify];
	}
	/**
	 * 得到完整的数据表名
	 * @access public
	 * @return string
	 */
	public function getTableName() {
		if (! $this->getConfig ( 'tablename' )) {
			$this->config ['tablename'] = strtolower ( substr ( get_class ( $this ), 0, - 5 ) );
		}
		$tableName = $this->getConfig ( 'db_prefix' ) ? $this->getConfig ( 'db_prefix' ) : Config::get ( 'database.db_prefix' );
		$tableName .= $this->getConfig ( 'tablename' );
		return strtolower ( ($this->getConfig ( 'db_name' ) ? $this->getConfig ( 'db_name' ) . '.' : '') . $tableName );
	}
	/**
	 * 获取模型名称
	 * @access public
	 * @return string
	 */
	public function getModelName() {
		if (empty ( $this->name )) {
			if ($this->config ['type'] == 'form') {
				$this->name = $this->config ['model'];
			}
			if (empty ( $this->name )) {
				$this->name = $this->config ['systemname'] ? $this->config ['systemname'] : strtolower ( substr ( get_class ( $this ), 0, - 5 ) );
			}
		
		}
		return $this->name;
	}
	/**
	 * 设置模型配置的值
	 * @access public
	 * @param string $name 名称
	 * @param mixed $value 值
	 * @return void
	 */
	public function setConfig($name, $value) {
		$this->config [$name] = $value;
	}
	/**
	 * 获取模型配置对象的值
	 * @access public
	 * @param string $name 名称
	 * @return mixed
	 */
	public function getConfig($name) {
		return isset ( $this->config [$name] ) ? $this->config [$name] : null;
	}
	/**
	 * 设置模型数据
	 * @param mixed $data 模型数据 支持对象 字符串 数组
	 */
	public function setData($data) {
		if ('' === $data && ! empty ( $this->data )) {
			return $this->data;
		}
		if (is_object ( $data )) {
			$data = get_object_vars ( $data );
		} elseif (is_string ( $data )) {
			parse_str ( $data, $data );
		} elseif (! is_array ( $data )) {
			Halt ( '非法操作' );
		}
		$this->data = array_merge ( $this->data, $data );
		array_walk_recursive ( $this->data, 'array_change_key_case' );
	}
	/**
	 * 获取所有模型值
	 */
	public function getData() {
		return $this->data;
	}
	/**
	 * 获取模型所有字段设置
	 */
	public function getFields() {
		return $this->fields;
	}
	
	/**
	 * 设置数据对象的值
	 * @access public
	 * @param string $name 名称
	 * @param mixed $value 值
	 * @return void
	 */
	public function __set($name, $value) {
		$this->data [$name] = $value;
	}
	
	/**
	 * 获取数据对象的值
	 * @access public
	 * @param string $name 名称
	 * @return mixed
	 */
	public function __get($name) {
		return isset ( $this->data [$name] ) ? $this->data [$name] : null;
	}
	
	/**
	 * 检测数据对象的值
	 * @access public
	 * @param string $name 名称
	 * @return boolean
	 */
	public function __isset($name) {
		return isset ( $this->data [$name] );
	}
	
	/**
	 * 销毁数据对象的值
	 * @access public
	 * @param string $name 名称
	 * @return void
	 */
	public function __unset($name) {
		unset ( $this->data [$name] );
	}
	
	/**
	 * 获取表单的数据
	 * @access public
	 * @param mixed $data 表单数据
	 * @return mixed
	 */
	public function getInput($data = '') {
		if (empty ( $data )) {
			$data = $_REQUEST;
			$this->data = $data [$this->name];
		} elseif (is_object ( $data )) {
			$this->data = get_object_vars ( $data );
		} else {
			$this->data = $data;
		}
		if (empty ( $this->data ) || ! is_array ( $this->data )) {
			$this->error = '非法操作';
			return false;
		}
		$fields = array_change_key_case ( $this->fields );
		$this->input = array ();
		foreach ( $fields as $key => $option ) {
			if ($option ['isreadonly'])
				continue;
			$key = strtolower ( $key );
			$val = isset ( $this->data [$key] ) ? $this->data [$key] : '';
			if (false === $this->validateField ( $option )) {
				return false;
			}
			switch ($option ['fieldtype']) {
				case 'datetimefield' :
					if ($option ['setting'] ['datatype'] == 'int')
						$val = strtotime ( $val );
					$this->input [$key] = $val;
					break;
				case 'ipfield' :
					if (empty ( $val ))
						$val = IP;
					$this->input [$key] = $val;
					break;
				case 'optionfield' :
					if ($option ['setting'] ['optiontype'] == 'checkbox') {
						if (! is_array ( $val ) || empty ( $val ))
							continue;
						$val = ',' . implode ( ',', $val ) . ',';
					}
					$this->input [$key] = $val;
					break;
				case 'passwordfield' :
					if ($val != '' && $val != '******') {
						$pwd = array ('type' => 'md5' );
						$pwd ['key'] = RandomStr ();
						$pwd ['password'] = Md5Encrypt::encrypt ( $val, $pwd ['key'] );
						$val = $pwd;
						$this->input [$key] = $val;
					}
					break;
				case 'textareafield' :
					if (! $option ['setting'] ['enablehtml']) {
						$val = htmlspecialchars ( strip_tags ( $val ) );
					} else {
						$val = FilterXSS ( $val );
					}
					$this->input [$key] = $val;
					break;
				case 'editorfield' :
					$val = FilterXSS ( $val );
					$this->input [$key] = $val;
					break;
				case 'uploadfield' :
					$file = array_shift ( $val );
					$val = $file ? $file ['url'] : '';
					$this->input [$key] = $val;
					break;
				default :
					$val = htmlspecialchars ( strip_tags ( $val ) );
					$this->input [$key] = $val;
			}
		
		}
		if (! empty ( $this->error ))
			return false;
		
		return $this->input;
	}
	
	/**
	 * 验证字段定义的所有规则
	 * @access public
	 * @param array $fieldinfo 字段信息
	 * @return boolean
	 */
	public function validateField($fieldinfo) {
		$data = $this->data;
		$value = $data [$fieldinfo ['systemname']];
		if (isset ( $fieldinfo ['rules'] ['required'] )) {
			$rule = $fieldinfo ['rules'] ['required'];
			unset ( $fieldinfo ['rules'] ['required'] );
			if (!$value) {
				$message = ! empty ( $rule ['message'] ) ? $rule ['message'] : $fieldinfo ['name'] . '必须填写';
				$this->error = $message;
				return false;
			}
		}
		if(!$value) return true;
		foreach ( $fieldinfo ['rules'] as $k => $rule ) {
			$type = strtolower ( trim ( $k ) );
			$result = true;
			switch ($type) {
				case 'unique' :
					$dataFields = ! empty ( $rule ['param'] ) ? explode ( ',', $rule ['param'] ) : array ();
					$dataFields [] = $fieldinfo ['systemname'];
					$map = array ();
					foreach ( $dataFields as $field ) {
						$map [$field] = $data [$field];
					}
					$field = Service::instance ( $this->name )->getPk ();
					
					if (! empty ( $data [$field] )) {
						$map [$field] = array ('neq', $data [$field] );
					}
					if (Service::instance ( $this->name )->where ( $map )->getOne ())
						$result = false;
					break;
				case 'regex' :
					if (isset ( $this->rules [$type] )) {
						$params = $this->rules [$type];
					} else {
						$params = '/^' . $rule ['param'] . '$/';
					}
					$result = preg_match ( $params, $value ) === 1;
			}
			if ($result === false) {
				$message = ! empty ( $rule ['message'] ) ? $rule ['message'] : $fieldinfo ['name'] . '验证未通过：' . strtolower ( $type );
				$this->error = $message;
				return false;
			}
		}
		return true;
	}
	
	/**
	 * 获取所属的模块
	 */
	public function getModule() {
		return $this->config ['module'];
	}
	
	/**
	 * 设置错误并返回false
	 * @access protected
	 * @param string $msg 错误提示
	 * @return bool
	 */
	protected function error($msg) {
		$this->error = $msg;
		return false;
	}
	/**
	 * 返回错误信息
	 * @access public
	 * @return string
	 */
	public function getError() {
		return $this->error;
	}
}

?>