<?php
defined ( 'BAIFU_PATH' ) or exit ( 'Access Denied' );
/**
 * 日志处理器
 */
class Logger {
	protected $config = array ('maxsize' => 1024000, 'savepath' => APP_FILE_LOG_PATH );
	protected static $default = array ('name' => 'file', 'errorlog' => true );
	const FATAL = 'fatal';
	const ERROR = 'error';
	const WARNING = 'warning';
	const NOTICE = 'notice';
	const INFO = 'info';
	const DEBUG = 'debug';
	
	/** 
	 * 取得类实例
	 * @static
	 * @access public
	 * @return Logger 返回类实例
	 */
	public static function instance($config = array()) {
		$args = func_get_args ();
		static $_instance = array ();
		$identify = Guid ( $args );
		if (! isset ( $_instance [$identify] )) {
			$config = self::parseConfig ( $config );
			$o = new Logger ();
			$o->init ( $config );
			$_instance [$identify] = $o;
		
		}
		return $_instance [$identify];
	}
	/**
	 * 解析配置
	 * @access public
	 * @param array $config 自定义配置
	 * @return string
	 */
	public static function parseConfig($config = array()) {
		if (is_string ( $config ))
			$config = array ('name' => $config );
		return array_merge ( self::$default, array_change_key_case ( $config ) );
	}
	public function init($config = array()) {
		$this->config = array_merge ( $this->config, $config );
	}
	public static function fatal($message) {
		self::instance ()->write ( $message, self::FATAL );
	}
	public static function error($message) {
		self::instance ()->write ( $message, self::ERROR );
	}
	public static function warning($message) {
		self::instance ()->write ( $message, self::WARNING );
	}
	public static function notice($message) {
		self::instance ()->write ( $message, self::NOTICE );
	}
	public static function info($message) {
		self::instance ()->write ( $message, self::INFO );
	}
	public static function debug($message) {
		self::instance ()->write ( $message, self::DEBUG );
	}
	
	/**
	 * 写入日志
	 * @access public
	 * @param string $message 日志信息
	 * @param string $type  日志类型
	 * @return void
	 */
	public function write($message, $type) {
		$path = $this->config ['savepath'] . date ( 'y_m_d' ) . '.log';
		if (! is_dir ( $this->config ['savepath'] )) {
			mkdir ( $this->config ['savepath'], 0755, true );
		}
		if (is_file ( $path ) && floor ( $this->config ['maxsize'] ) <= filesize ( $path ))
			rename ( $path, dirname ( $path ) . '/' . time () . '-' . basename ( $path ) );
		
		$message = date ( 'Y-m-d H:i:s' ) . $_SERVER ['REMOTE_ADDR'] . ' ' . $_SERVER ['REQUEST_URI'] . ' [' . $type . '] ' . $message . "\r\n";
		$fp = fopen ( $path, "a" );
		flock ( $fp, LOCK_EX );
		fwrite ( $fp, $message );
		flock ( $fp, LOCK_UN );
		fclose ( $fp );
	}

}
Config::set ( 'log', Logger::parseConfig () );
?>
