<?php
defined('BAIFU_PATH') or exit('Access Denied');
/**
 * Cookie类
 */
class  Cookie{
	protected static $default = array (
		'domain'=>'',
		'expire' => 0, 
		'path' => '/',
		'prefix' => '',
	);
	protected static $config = array ();
	/**
	 * 初始化配置
	 * @access public
	 * @param array $config 自定义配置
	 * @return array
	 */
	public static function init($config = array()) {
		return self::$config = array_merge ( self::$default, array_change_key_case ( $config ) );
	}
	/**
	 * 取得变量名
	 * @access private
	 * @param string $name 缓存变量名
	 * @return string
	 */
	private static function getName($name) {
		return self::$config ['prefix'] . $name;
	}
	
	/**
	 * 获取指定Cookie值
	 * @param string $name
	 */
	public static function get($name) {
		$name = self::getName ( $name );
		if (! isset ( $_COOKIE [$name] ))
			return null;
		$value = $_COOKIE [$name];
		$value = unserialize ( base64_decode ( $value ) );
		return $value;
	}
	
	/**
	 * 设置Cookie
	 * @param string $name
	 * @param string $value
	 * @param int $expire
	 * @param string $path
	 * @param string $domain
	 */
	public static function set($name, $value, $expire = null, $path = null, $domain = null) {
		$name = self::getName ( $name );
		if (is_null ( $expire )) {
			$expire = self::$config ['expire'];
		}
		if (is_null ( $path )) {
			$path = self::$config ['path'];
		}
		if (is_null ( $domain )) {
			$domain = self::$config ['domain'];
		}
		$expire = ! empty ( $expire ) ? time () + $expire : 0;
		$value = base64_encode ( serialize ( $value ) );
		setcookie ( $name, $value, $expire, $path, $domain );
		$_COOKIE [$name] = $value;
	}

    /**
     * 删除指定Cookie
     * @param string $name
     */
    public static function delete($name) {
        Cookie::set($name,'',-86400);
        unset($_COOKIE[$name]);
    }

    /**
     * 清空Cookie
     */
    public static function clear() {
        unset($_COOKIE);
    }
 
}
Cookie::init();