<?php
defined ( 'BAIFU_PATH' ) or exit ( 'Access Denied' );
/**
 * 控制器抽象类
 */
abstract class Controller {
	
	/**
	 * 当前控制器名称
	 */
	protected $name = '';
	
	/**
	 * 控制器参数
	 */
	protected $config = array ();
	/**
	 * 模板布局
	 */
	protected $layout = true;
	/**
	 * 是否启用提示 直接跳转
	 */
	protected $isnotify = false;
	/**
	 * 模板参数
	 */
	protected $params = array ();
	
	/**
	 * 错误信息
	 */
	protected $error = '';
	/**
	 * 返回错误信息
	 * @access public
	 * @return string
	 */
	public function getError() {
		return $this->error;
	}
	/**
	 * 架构函数 取得模板对象实例
	 * @access public
	 */
	public function __construct() {
		$this->_init ();
		$this->checkPermission ();
	}
	/**
	 * 设置数据对象的值
	 * @access public
	 * @param string $name 名称
	 * @param mixed $value 值
	 * @return void
	 */
	public function __set($name, $value) {
		$this->params [$name] = $value;
	}
	
	/**
	 * 获取数据对象的值
	 * @access public
	 * @param string $name 名称
	 * @return mixed
	 */
	public function __get($name) {
		return isset ( $this->params [$name] ) ? $this->params [$name] : null;
	}
	
	/**
	 * 检测数据对象的值
	 * @access public
	 * @param string $name 名称
	 * @return boolean
	 */
	public function __isset($name) {
		return isset ( $this->params [$name] );
	}
	
	/**
	 * 销毁数据对象的值
	 * @access public
	 * @param string $name 名称
	 * @return void
	 */
	public function __unset($name) {
		unset ( $this->params [$name] );
	}
	
	/**
	 * 魔术方法 有不存在的操作的时候执行
	 * @access public
	 * @param string $method 方法名
	 * @param array $args 参数
	 * @return mixed
	 */
	public function __call($method, $args) {
		if (method_exists ( $this, '_common' )) {
			$this->_common ( $method, $args );
		} else {
			NotFound ( __CLASS__ . ':' . Baifu::get ( 'a' ) . '方法不存在' );
		}
	}
	/**
	 * 初始化
	 */
	protected function _init() {
	}
	/**
	 * 权限检测
	 */
	protected function checkPermission() {
		return true;
	}
	/**
	 * 获取当前控制器名称
	 * @access protected
	 */
	protected function getControllerName() {
		if (empty ( $this->name )) {
			$this->name = substr ( get_class ( $this ), 0, - 10 );
		}
		return strtolower ( $this->name );
	}
	
	/**
	 * 模板参数赋值
	 * @access public
	 * @param mixed $name
	 * @param mixed $value
	 */
	public function setParams($name, $value = '') {
		if (is_array ( $name )) {
			$this->params = array_merge ( $this->params, $name );
		} else {
			$this->params [$name] = $value;
		}
	}
	
	/**
	 * 操作错误跳转的快捷方法
	 * @access protected
	 * @param string $message 错误信息
	 * @param string $forward 页面跳转地址
	 * @param mixed $time 指定跳转时间
	 * @return void
	 */
	protected function error($message = '', $forward = '', $time = 5) {
		if (empty ( $forward )) {
			$forward = 'goback';
		}
		$this->message ( $message, 0, $forward, $time );
	}
	
	/**
	 * 操作成功跳转的快捷方法
	 * @access protected
	 * @param string $message 提示信息
	 * @param string $forward 页面跳转地址
	 * @param mixed $time 指定跳转时间
	 * @return void
	 */
	protected function success($message = '', $forward = '', $time = 5) {
		$this->message ( $message, 1, $forward, $time );
	}
	
	/**
	 * Ajax输出数据
	 * @access protected
	 * @param mixed $data 要返回的数据
	 * @param String $type 数据类型
	 * @param string $charset 输出编码
	 * @return void
	 */
	protected function ajax($data, $type = 'json', $charset = 'utf-8') {
		Response ( $data, $type, $charset );
	}
	
	/**
	 * Url跳转
	 * @access protected
	 * @param string $url 跳转的URL表达式
	 * @param array $params 其它URL参数
	 * @param integer $delay 延时跳转的时间 单位为秒
	 * @param string $msg 跳转提示信息
	 * @return void
	 */
	protected function redirect($url, $params = array(), $delay = 0, $msg = '') {
		$url = Url ( $url, $params );
		Redirect ( $url, $delay, $msg );
	}
	/**
	 * 提示跳转
	 * @access protected
	 * @param string $message 消息
	 * @param int $status 状态码
	 * @param string $forward 跳转地址
	 * @param int $delay 延时跳转的时间 单位为秒
	 * @return void
	 */
	protected function message($message, $status = 1, $forward = '', $time = 5) {
		if (IS_AJAX) {
			$data = array ();
			$data ['message'] = $message;
			$data ['status'] = $status;
			$data ['forward'] = $forward;
			$this->ajax ( $data );
		}
		if (empty ( $forward )) {
			if ($_REQUEST ['forward']) {
				$forward = $_REQUEST ['forward'];
			} else if (Cookie::get ( 'forward' )) {
				$forward = Cookie::get ( 'forward' );
				Cookie::delete ( 'forward' );
			} else {
				$forward = WEB_HTTP_REFERER;
			}
		}
		$statusArray = array ('error', 'success', 'info' );
		if (isset ( $statusArray [$status] )) {
			$status = $statusArray [$status];
		}
		if ($this->isnotify) {
			$this->notify ( $message, $status, $forward, $forward );
			return;
		}
		include BAIFU_PATH . 'view/message.tpl.php';
		exit ();
	}
	/**
	 * 记录提示信息
	 * @param string $message
	 * @param int $status
	 */
	protected function notify($message, $status = 'success', $forward = '') {
		$notify = json_decode ( Cookie::get ( 'notify' ), true );
		if (! is_array ( $notify ))
			$notify = array ();
		$notify [$status] [] = $message;
		Cookie::set ( 'notify', json_encode ( $notify ) );
		if (! empty ( $forward ))
			Redirect ( $forward );
	}
	
	/**
	 * 输出模板视图
	 * @access protected
	 * @param string $template 模板文件
	 * @param string $type 输出类型
	 * @param string $charset 输出编码
	 * @return void
	 */
	protected function view($template = '', $type = '', $charset = '') {
		$content = $this->fetch ( $template );
		Response ( $content, $type, $charset );
	}
	/**
	 * 输出内容
	 * @access protected
	 * @param string $content 内容
	 * @param string $type 输出类型
	 * @param string $charset 输出编码
	 * @return void
	 */
	protected function content($content = '', $charset = '', $type = '') {
		$content = $this->fetch ( $content, true );
		Response ( $content, $type, $charset );
	}
	/**
	 * 获取模板内容
	 * @access protected
	 * @param string $data 模板或内容
	 * @param string $iscontent 是否为内容
	 * @return string
	 */
	protected function fetch($_data = '', $_iscontent = false) {
		if ($_iscontent == false) {
			if (! file_exists ( $_data ))
				$_data = Template::path ( $_data );
		}
		$engine = strtolower ( Config::get ( 'default.template_engine' ) );
		ob_start ();
		ob_implicit_flush ( 0 );
		extract ( $this->params, EXTR_OVERWRITE );
		if ('php' == $engine) {
			if ($_iscontent) {
				echo $_data;
			} else {
				include $_data;
			}
		} else {
			$template = Template::instance ( $engine );
			if ($_iscontent == false) {
				include $template->compileFile ( $_data, $this->layout );
			} else {
				include $template->compileContent ( $_data );
			}
		}
		$content = ob_get_clean ();
		return $content;
	}
	
	/**
	 * 析构方法
	 * @access public
	 */
	public function __destruct() {
	}
}