<?php
/**
 * Baifu 系统函数
 */

/**
 * 返回经addslashes处理过的字符串或数组
 * @param $string 需要处理的字符串或数组
 * @return mixed
 */
function New_addslashes($string) {
	if (is_array ( $string )) {
		return array_map ( 'New_addslashes', $string );
	} else {
		return addslashes ( $string );
	}
}

/**
 * 返回经stripslashes处理过的字符串或数组
 * @param $string 需要处理的字符串或数组
 * @return mixed
 */
function New_stripslashes($string) {
	if (is_array ( $string )) {
		return array_map ( 'New_stripslashes', $string );
	} else {
		return stripslashes ( $string );
	}
}

/**
 * 返回经htmlspecialchars处理过的字符串或数组
 * @param $obj 需要处理的字符串或数组
 * @return mixed
 */
function New_htmlspecialchars($string) {
	if (is_array ( $string )) {
		return array_map ( 'New_htmlspecialchars', $string );
	} else {
		return htmlspecialchars ( $string );
	}
}
/**
 * 格式化日期 处理时间为空的情况输出空
 * @return string
 */
function New_date($format, $time) {
	if (! $time) {
		return '';
	}
	return date ( $format, $time );
}
/**
 * 过滤处理XSS跨站脚本
 * @param mixed $string
 * @return mixed
 */
function FilterXSS($string) {
	if (is_array ( $string )) {
		return array_map ( 'FilterXSS', $string );
	} else {
		if (strlen ( $string ) < 20)
			return $string;
		$match = array ("/&#([a-z0-9]+)([;]*)/i", "/(j[\s\r\n\t]*a[\s\r\n\t]*v[\s\r\n\t]*a[\s\r\n\t]*s[\s\r\n\t]*c[\s\r\n\t]*r[\s\r\n\t]*i[\s\r\n\t]*p[\s\r\n\t]*t|jscript|js|vbscript|vbs|about|expression|script|frame|link|import)/i", "/on(mouse|exit|error|click|dblclick|key|load|unload|change|move|submit|reset|cut|copy|select|start|stop)/i" );
		$replace = array ("", "<d>\\1</d>", "on\n\\1" );
		return preg_replace ( $match, $replace, $string );
	}
}
/**
 * 过滤处理Sql脚本
 * @param mixed $string
 * @return mixed
 */
function FilterSql($string) {
	if (is_array ( $string )) {
		return array_map ( 'FilterSql', $string );
	} else {
		$match = array ("/union[\s|\t]/i", "/select[\s|\t]/i", "/update[\s|\t]/i", "/outfile[\s|\t]/i", "/ascii/i", "/[\s|\t]or[\s|\t]/i", "/\/\*/i" );
		$replace = array ('union&nbsp;', 'select&nbsp;', 'update&nbsp;', 'outfile&nbsp;', 'ascii&nbsp;', '&nbsp;or&nbsp;', '&nbsp;' );
		return preg_replace ( $match, $replace, $string );
	}
}

/**
 * 过滤不安全字符
 * @param $string
 * @return string
 */
function FilterUnsafeChars($string) {
	$string = str_replace ( '%20', '', $string );
	$string = str_replace ( '%27', '', $string );
	$string = str_replace ( '%2527', '', $string );
	$string = str_replace ( '*', '', $string );
	$string = str_replace ( '"', '&quot;', $string );
	$string = str_replace ( "'", '', $string );
	$string = str_replace ( '"', '', $string );
	$string = str_replace ( ';', '', $string );
	$string = str_replace ( '<', '&lt;', $string );
	$string = str_replace ( '>', '&gt;', $string );
	$string = str_replace ( "{", '', $string );
	$string = str_replace ( '}', '', $string );
	$string = str_replace ( '\\', '', $string );
	return $string;
}

/**
 * 过滤ASCII码从0-28的控制字符
 * @return String
 */
function FilterAsciiChars($str) {
	$rule = '/[' . chr ( 1 ) . '-' . chr ( 8 ) . chr ( 11 ) . '-' . chr ( 12 ) . chr ( 14 ) . '-' . chr ( 31 ) . ']*/';
	return str_replace ( chr ( 0 ), '', preg_replace ( $rule, '', $str ) );
}

/**
 * 格式化文本域内容
 * @param $string 文本域内容
 * @return string
 */
function FormatTextarea($string) {
	$string = nl2br ( str_replace ( ' ', '&nbsp;', $string ) );
	return $string;
}

/**
 * 将文本格式成适合js输出的字符串
 * @param string $string 需要处理的字符串
 * @param intval $isjs 是否执行字符串格式化，默认为执行
 * @return string 处理后的字符串
 */
function FormatJs($string, $isjs = 1) {
	$string = addslashes ( str_replace ( array ("\r", "\n", "\t" ), array ('', '', '' ), $string ) );
	return $isjs ? 'document.write("' . $string . '");' : $string;
}
/**
 * 字符截取 支持UTF8/GBK
 * @param $string
 * @param $length
 * @param $dot
 */
function CutString($string, $length, $dot = '...') {
	$strlen = strlen ( $string );
	if ($strlen <= $length)
		return $string;
	$string = str_replace ( array (' ', '&nbsp;', '&amp;', '&quot;', '&#039;', '&ldquo;', '&rdquo;', '&mdash;', '&lt;', '&gt;', '&middot;', '&hellip;' ), array ('∵', ' ', '&', '"', "'", '“', '”', '—', '<', '>', '·', '…' ), $string );
	$strcut = '';
	if (strtolower ( Config::get ( 'default.charset' ) ) == 'utf-8') {
		$length = intval ( $length - strlen ( $dot ) - $length / 3 );
		$n = $tn = $noc = 0;
		while ( $n < strlen ( $string ) ) {
			$t = ord ( $string [$n] );
			if ($t == 9 || $t == 10 || (32 <= $t && $t <= 126)) {
				$tn = 1;
				$n ++;
				$noc ++;
			} elseif (194 <= $t && $t <= 223) {
				$tn = 2;
				$n += 2;
				$noc += 2;
			} elseif (224 <= $t && $t <= 239) {
				$tn = 3;
				$n += 3;
				$noc += 2;
			} elseif (240 <= $t && $t <= 247) {
				$tn = 4;
				$n += 4;
				$noc += 2;
			} elseif (248 <= $t && $t <= 251) {
				$tn = 5;
				$n += 5;
				$noc += 2;
			} elseif ($t == 252 || $t == 253) {
				$tn = 6;
				$n += 6;
				$noc += 2;
			} else {
				$n ++;
			}
			if ($noc >= $length) {
				break;
			}
		}
		if ($noc > $length) {
			$n -= $tn;
		}
		$strcut = substr ( $string, 0, $n );
		$strcut = str_replace ( array ('∵', '&', '"', "'", '“', '”', '—', '<', '>', '·', '…' ), array (' ', '&amp;', '&quot;', '&#039;', '&ldquo;', '&rdquo;', '&mdash;', '&lt;', '&gt;', '&middot;', '&hellip;' ), $strcut );
	} else {
		$dotlen = strlen ( $dot );
		$maxi = $length - $dotlen - 1;
		$current_str = '';
		$search_arr = array ('&', ' ', '"', "'", '“', '”', '—', '<', '>', '·', '…', '∵' );
		$replace_arr = array ('&amp;', '&nbsp;', '&quot;', '&#039;', '&ldquo;', '&rdquo;', '&mdash;', '&lt;', '&gt;', '&middot;', '&hellip;', ' ' );
		$search_flip = array_flip ( $search_arr );
		for($i = 0; $i < $maxi; $i ++) {
			$current_str = ord ( $string [$i] ) > 127 ? $string [$i] . $string [++ $i] : $string [$i];
			if (in_array ( $current_str, $search_arr )) {
				$key = $search_flip [$current_str];
				$current_str = str_replace ( $search_arr [$key], $replace_arr [$key], $current_str );
			}
			$strcut .= $current_str;
		}
	}
	return $strcut . $dot;
}

/**
 * 生成随机字符串
 * @param    int        $length  输出长度
 * @param    string     $chars   可选的 ，默认为 0123456789
 * @return   string     字符串
 */
function Random($length, $chars = '0123456789') {
	$hash = '';
	$max = strlen ( $chars ) - 1;
	for($i = 0; $i < $length; $i ++) {
		$hash .= $chars [mt_rand ( 0, $max )];
	}
	return $hash;
}

/**
 * 生成[a-z1-9A-2]随机字符串
 * @param string $lenth 长度
 * @return string 字符串
 */
function RandomStr($lenth = 6) {
	return Random ( $lenth, '123456789abcdefghijklmnpqrstuvwxyzABCDEFGHIJKLMNPQRSTUVWXYZ' );
}
/**
 * 转换字节数为其他单位
 * @param	string	$filesize	字节大小
 * @return	string	返回大小
 */
function FormatSize($filesize) {
	if ($filesize >= 1073741824) {
		$filesize = round ( $filesize / 1073741824 * 100 ) / 100 . ' GB';
	} elseif ($filesize >= 1048576) {
		$filesize = round ( $filesize / 1048576 * 100 ) / 100 . ' MB';
	} elseif ($filesize >= 1024) {
		$filesize = round ( $filesize / 1024 * 100 ) / 100 . ' KB';
	} else {
		$filesize = $filesize . ' Bytes';
	}
	return $filesize;
}
/**
 * 取得文件扩展
 * @param $filename 文件名
 * @return 扩展名
 */
function Extention($filename) {
	return strtolower ( pathinfo ( $filename, PATHINFO_EXTENSION ) );
}
/**
 * 是否为图片
 * @param $filename 文件名
 * @return 扩展名
 */
function IsImage($filename) {
	return preg_match ( "/^(jpg|jpeg|gif|png|bmp)$/i", Extention ( $filename ) );
}

/**
 * 编码转换
 */
function Encoding($content, $from = 'gbk', $to = 'utf-8') {
	$from = strtoupper ( $from ) == 'UTF8' ? 'utf-8' : $from;
	$to = strtoupper ( $to ) == 'UTF8' ? 'utf-8' : $to;
	if (strtoupper ( $from ) === strtoupper ( $to ) || empty ( $content ) || (is_scalar ( $content ) && ! is_string ( $content ))) {
		return $content;
	}
	if (is_string ( $content )) {
		if (function_exists ( 'mb_convert_encoding' )) {
			return mb_convert_encoding ( $content, $to, $from );
		} elseif (function_exists ( 'iconv' )) {
			return iconv ( $from, $to, $content );
		} else {
			return $content;
		}
	} elseif (is_array ( $content )) {
		foreach ( $content as $key => $val ) {
			$_key = Encoding ( $key, $from, $to );
			$content [$_key] = Encoding ( $val, $from, $to );
			if ($key != $_key)
				unset ( $content [$key] );
		}
		return $content;
	} else {
		return $content;
	}
}


/**
 * 将当前 Unix时间戳以及微秒数转换成浮点数
 */
function MicrotimeFloat() {
	list ( $usec, $sec ) = explode ( " ", microtime () );
	return (( float ) $usec + ( float ) $sec);
}

/**
 * 优化的require_once
 * @param string $filename 文件地址
 * @return boolean
 */
function RequireOnce($filename) {
	static $_importFiles = array ();
	$filename = strtolower ( $filename );
	if (! isset ( $_importFiles [$filename] )) {
		if (file_exists ( $filename )) {
			require $filename;
			$_importFiles [$filename] = true;
		} else {
			$_importFiles [$filename] = false;
		}
	}
	return $_importFiles [$filename];
}

/**
 * 获取表名称
 * @param string $modelName 模型名称
 * @return string
 */
function TableName($modelName) {
	$class = $modelName . 'Table';
	if (class_exists ( $class )) {
		$model = new $class ();
	} else {
		$model = new Table ();
		$model->setConfig ( 'tablename', $modelName );
	}
	return $model->getTableName ();
}

/**
 * 错误输出
 * @param mixed $error 错误
 * @return void
 */
function Halt($error) {
	$error_page = Config::get ( 'default.errorpage' );
	if (! APP_DEBUG && $error_page) {
		Redirect ( $error_page );
	}
	$message = array ();
	$message [] = is_array ( $error ) ? $error ['message'] : $error;
	$e = array ();
	if (APP_DEBUG) {
		if (! is_array ( $error )) {
			$trace = debug_backtrace ();
			$e ['file'] = $trace [0] ['file'];
			$e ['line'] = $trace [0] ['line'];
			ob_start ();
			debug_print_backtrace ();
			$e ['trace'] = ob_get_clean ();
		} else {
			$e = $error;
		}
		if ($e ['file']) {
			$message [] = 'File: ' . $e ['file'];
			$message [] = 'Line: ' . $e ['line'];
		}
		if ($e ['trace'])
			$message [] = 'Trace: ' . $e ['trace'];
	}
	Response ( implode ( '<br/>', $message ) );
	exit ();
}

/**
 * 自定义异常处理
 * @param string $msg 异常消息
 * @param string $type 异常类型
 * @param integer $code 异常代码
 * @return void
 */
function ThrowException($msg, $type = 'BaifuException', $code = 0) {
	if (class_exists ( $type, false )) {
		throw new $type ( $msg, $code );
	} else {
		Halt ( $msg );
	}
}

/**
 * 输出404提示
 * @param string $message 提示信息
 * @param string $url 友好提示页
 * @return void
 */
function NotFound($message = '', $url = '') {
	APP_DEBUG && ThrowException ( $message );
	if ($message && Config::get ( 'log.notfound' ))
		Logger::error ( $message );
	if (empty ( $url ) && Config::get ( 'default.notfound' )) {
		$url = Config::get ( 'default.notfound' );
	}
	
	if ($url) {
		Redirect ( $url );
	} else {
		SendHttpStatus ( 404 );
		exit ();
	}
}

/**
 * 生成URL
 * @param string|array $url URL表达式
 * @param string|array $vars 附加参数
 * @return string
 */
function Url($url = '', $vars = '') {
	if (is_string ( $vars )) {
		parse_str ( $vars, $vars );
	} elseif (! is_array ( $vars )) {
		$vars = array ();
	}
	if (! is_array ( $url )) {
		$info = parse_url ( $url );
		$path = $info ['path'];
		if (isset ( $info ['fragment'] )) {
			$anchor = $info ['fragment'];
		}
		
		if (isset ( $info ['query'] )) {
			parse_str ( $info ['query'], $params );
			$vars = array_merge ( $params, $vars );
		}
		$path = trim ( $path, '/' );
		$params = array_reverse ( explode ( '/', $path ) );
		$vars ['a'] = $params [0] ? $params [0] : Baifu::get ( 'a' );
		$vars ['c'] = $params [1] ? $params [1] : Baifu::get ( 'c' );
		$vars ['m'] = $params [2] ? $params [2] : Baifu::get ( 'm' );
		if (isset ( $params [3] )) {
			$vars ['_file_'] = $params [3];
		}
		if ($info ['host']) {
			$domain = $info ['host'];
		}
	} else {
		$vars = array_merge ( $url, $vars );
		foreach ( array ('m', 'c', 'a' ) as $v ) {
			if (! isset ( $vars [$v] )) {
				$vars [$v] == Baifu::get ( $v );
			}
		}
	}
	$vars = array_change_key_case ( $vars );
	ksort ( array_filter ( $vars ) );
	foreach ( array ('m', 'c', 'a' ) as $v ) {
		if (isset ( $vars [$v] ) && $vars [$v] == Config::get ( 'default.' . $v )) {
			unset ( $vars [$v] );
		}
	}
	$file = basename ( WEB_SCRIPT_NAME, ".php" );
	;
	if (isset ( $vars ['_anchor_'] )) {
		$anchor = $vars ['_anchor_'];
		unset ( $vars ['_anchor_'] );
	}
	
	$url = WEB_ROOT . $file . '.php?' . urldecode ( http_build_query ( $vars ) );
	if (isset ( $anchor )) {
		$url .= '#' . $anchor;
	}
	if ($domain) {
		$url = WEB_SCHEME . $domain . $url;
	}
	return $url;
}
/**
 * 绝对网址和相对网址相互转换
 */
function UrlFormat($url, $isabsurl = true) {
	if ($isabsurl) {
		if (strpos ( $url, '://' ) !== false)
			return $url;
		return strpos ( $url, WEB_ROOT ) === 0 ? WEB_URL . substr ( $url, strlen ( WEB_ROOT ) ) : WEB_URL . $url;
	} else {
		if (strpos ( $url, '://' ) !== false)
			return strpos ( $url, WEB_URL ) === 0 ? WEB_ROOT . substr ( $url, strlen ( WEB_URL ) ) : $url;
		return strpos ( $url, WEB_ROOT ) === 0 ? $url : WEB_ROOT . $url;
	}
}
/**
 * 判断是否SSL协议
 * @return boolean
 */
function IsSsl() {
	if (isset ( $_SERVER ['HTTPS'] ) && ('1' == $_SERVER ['HTTPS'] || 'on' == strtolower ( $_SERVER ['HTTPS'] ))) {
		return true;
	} elseif (isset ( $_SERVER ['SERVER_PORT'] ) && ('443' == $_SERVER ['SERVER_PORT'])) {
		return true;
	}
	return false;
}
/**
 * 返回数据到客户端
 * @param mixed $data 要返回的数据
 * @param String $type 返回数据格式
 * @param string $charset 输出编码
 * @return void
 */
function Response($data, $type = 'html', $charset = 'utf-8') {
	if (empty ( $charset ))
		$charset = Config::get ( 'default.charset' );
	switch (strtoupper ( $type )) {
		case 'JSON' :
			header ( 'Content-Type:application/json; charset=' . $charset );
			exit ( json_encode ( $data ) );
		case 'JAVASCRIPT' :
			header ( 'Content-Type:text/html; charset=' . $charset );
			exit ( FormatJs ( $data ) );
		default :
			header ( 'Content-Type:text/html; charset=' . $charset );
			exit ( $data );
	
	}
}
/**
 * 获取当前请求的Accept头信息
 * @return string
 */
function GetAcceptType() {
	$type = array ('html' => 'text/html,application/xhtml+xml,*/*', 'xml' => 'application/xml,text/xml,application/x-xml', 'json' => 'application/json,text/x-json,application/jsonrequest,text/json', 'js' => 'text/javascript,application/javascript,application/x-javascript', 'css' => 'text/css', 'rss' => 'application/rss+xml', 'yaml' => 'application/x-yaml,text/yaml', 'atom' => 'application/atom+xml', 'pdf' => 'application/pdf', 'text' => 'text/plain', 'png' => 'image/png', 'jpg' => 'image/jpg,image/jpeg,image/pjpeg', 'gif' => 'image/gif', 'csv' => 'text/csv' );
	
	foreach ( $type as $key => $val ) {
		$array = explode ( ',', $val );
		foreach ( $array as $k => $v ) {
			if (stristr ( $_SERVER ['HTTP_ACCEPT'], $v )) {
				return $key;
			}
		}
	}
	return false;
}
/**
 * 设置页面输出的CONTENT_TYPE和编码
 * @access public
 * @param string $type content_type 类型对应的扩展名
 * @param string $charset 页面输出编码
 * @return void
 */
function SetContentType($type = 'html', $charset = 'utf-8') {
	if (headers_sent ())
		return;
	if (empty ( $charset ))
		$charset = Config::get ( 'default.charset' );
	$types = array ('acx' => 'application/internet-property-stream', 'ai' => 'application/postscript', 'aif' => 'audio/x-aiff', 'aifc' => 'audio/x-aiff', 'aiff' => 'audio/x-aiff', 'asp' => 'text/plain', 'aspx' => 'text/plain', 'asf' => 'video/x-ms-asf', 'asr' => 'video/x-ms-asf', 'asx' => 'video/x-ms-asf', 'au' => 'audio/basic', 'avi' => 'video/x-msvideo', 'axs' => 'application/olescript', 'bas' => 'text/plain', 'bcpio' => 'application/x-bcpio', 'bin' => 'application/octet-stream', 'bmp' => 'image/bmp', 'c' => 'text/plain', 'cat' => 'application/vnd.ms-pkiseccat', 'cdf' => 'application/x-cdf', 'cer' => 'application/x-x509-ca-cert', 'class' => 'application/octet-stream', 'clp' => 'application/x-msclip', 'cmx' => 'image/x-cmx', 'cod' => 'image/cis-cod', 'cpio' => 'application/x-cpio', 'crd' => 'application/x-mscardfile', 'crl' => 'application/pkix-crl', 'crt' => 'application/x-x509-ca-cert', 'csh' => 'application/x-csh', 'css' => 'text/css', 'dcr' => 'application/x-director', 'der' => 'application/x-x509-ca-cert', 'dir' => 'application/x-director', 'dll' => 'application/x-msdownload', 'dms' => 'application/octet-stream', 'doc' => 'application/msword', 'dot' => 'application/msword', 'dvi' => 'application/x-dvi', 'dxr' => 'application/x-director', 'eps' => 'application/postscript', 'etx' => 'text/x-setext', 'evy' => 'application/envoy', 'exe' => 'application/octet-stream', 'fif' => 'application/fractals', 'flr' => 'x-world/x-vrml', 'flv' => 'video/x-flv', 'gif' => 'image/gif', 'gtar' => 'application/x-gtar', 'gz' => 'application/x-gzip', 'h' => 'text/plain', 'hdf' => 'application/x-hdf', 'hlp' => 'application/winhlp', 'hqx' => 'application/mac-binhex40', 'hta' => 'application/hta', 'htc' => 'text/x-component', 'htm' => 'text/html', 'html' => 'text/html', 'htt' => 'text/webviewhtml', 'ico' => 'image/x-icon', 'ief' => 'image/ief', 'iii' => 'application/x-iphone', 'ins' => 'application/x-internet-signup', 'isp' => 'application/x-internet-signup', 'jfif' => 'image/pipeg', 'jpe' => 'image/jpeg', 'jpeg' => 'image/jpeg', 'jpg' => 'image/jpeg', 'js' => 'application/x-javascript', 'latex' => 'application/x-latex', 'lha' => 'application/octet-stream', 'lsf' => 'video/x-la-asf', 'lsx' => 'video/x-la-asf', 'lzh' => 'application/octet-stream', 'm13' => 'application/x-msmediaview', 'm14' => 'application/x-msmediaview', 'm3u' => 'audio/x-mpegurl', 'man' => 'application/x-troff-man', 'mdb' => 'application/x-msaccess', 'me' => 'application/x-troff-me', 'mht' => 'message/rfc822', 'mhtml' => 'message/rfc822', 'mid' => 'audio/mid', 'mny' => 'application/x-msmoney', 'mov' => 'video/quicktime', 'movie' => 'video/x-sgi-movie', 'mp2' => 'video/mpeg', 'mp3' => 'audio/mpeg', 'mpa' => 'video/mpeg', 'mpe' => 'video/mpeg', 'mpeg' => 'video/mpeg', 'mpg' => 'video/mpeg', 'mpp' => 'application/vnd.ms-project', 'mpv2' => 'video/mpeg', 'ms' => 'application/x-troff-ms', 'mvb' => 'application/x-msmediaview', 'nws' => 'message/rfc822', 'oda' => 'application/oda', 'p10' => 'application/pkcs10', 'p12' => 'application/x-pkcs12', 'p7b' => 'application/x-pkcs7-certificates', 'p7c' => 'application/x-pkcs7-mime', 'p7m' => 'application/x-pkcs7-mime', 'p7r' => 'application/x-pkcs7-certreqresp', 'p7s' => 'application/x-pkcs7-signature', 'pbm' => 'image/x-portable-bitmap', 'pdf' => 'application/pdf', 'pfx' => 'application/x-pkcs12', 'pgm' => 'image/x-portable-graymap', 'php' => 'text/plain', 'pko' => 'application/ynd.ms-pkipko', 'pma' => 'application/x-perfmon', 'pmc' => 'application/x-perfmon', 'pml' => 'application/x-perfmon', 'pmr' => 'application/x-perfmon', 'pmw' => 'application/x-perfmon', 'png' => 'image/png', 'pnm' => 'image/x-portable-anymap', 'pot,' => 'application/vnd.ms-powerpoint', 'ppm' => 'image/x-portable-pixmap', 'pps' => 'application/vnd.ms-powerpoint', 'ppt' => 'application/vnd.ms-powerpoint', 'prf' => 'application/pics-rules', 'ps' => 'application/postscript', 'pub' => 'application/x-mspublisher', 'qt' => 'video/quicktime', 'ra' => 'audio/x-pn-realaudio', 'ram' => 'audio/x-pn-realaudio', 'ras' => 'image/x-cmu-raster', 'rgb' => 'image/x-rgb', 'rmi' => 'audio/mid', 'roff' => 'application/x-troff', 'rtf' => 'application/rtf', 'rtx' => 'text/richtext', 'scd' => 'application/x-msschedule', 'sct' => 'text/scriptlet', 'setpay' => 'application/set-payment-initiation', 'setreg' => 'application/set-registration-initiation', 'sh' => 'application/x-sh', 'shar' => 'application/x-shar', 'sit' => 'application/x-stuffit', 'snd' => 'audio/basic', 'spc' => 'application/x-pkcs7-certificates', 'spl' => 'application/futuresplash', 'src' => 'application/x-wais-source', 'sst' => 'application/vnd.ms-pkicertstore', 'stl' => 'application/vnd.ms-pkistl', 'stm' => 'text/html', 'svg' => 'image/svg+xml', 'sv4cpio' => 'application/x-sv4cpio', 'sv4crc' => 'application/x-sv4crc', 'swf' => 'application/x-shockwave-flash', 't' => 'application/x-troff', 'tar' => 'application/x-tar', 'tcl' => 'application/x-tcl', 'tex' => 'application/x-tex', 'texi' => 'application/x-texinfo', 'texinfo' => 'application/x-texinfo', 'tgz' => 'application/x-compressed', 'tif' => 'image/tiff', 'tiff' => 'image/tiff', 'tr' => 'application/x-troff', 'trm' => 'application/x-msterminal', 'tsv' => 'text/tab-separated-values', 'txt' => 'text/plain', 'uls' => 'text/iuls', 'ustar' => 'application/x-ustar', 'vcf' => 'text/x-vcard', 'vrml' => 'x-world/x-vrml', 'wav' => 'audio/x-wav', 'wcm' => 'application/vnd.ms-works', 'wdb' => 'application/vnd.ms-works', 'wks' => 'application/vnd.ms-works', 'wmf' => 'application/x-msmetafile', 'wmv' => 'video/x-ms-wmv', 'wps' => 'application/vnd.ms-works', 'wri' => 'application/x-mswrite', 'wrl' => 'x-world/x-vrml', 'wrz' => 'x-world/x-vrml', 'xaf' => 'x-world/x-vrml', 'xbm' => 'image/x-xbitmap', 'xla' => 'application/vnd.ms-excel', 'xlc' => 'application/vnd.ms-excel', 'xlm' => 'application/vnd.ms-excel', 'xls' => 'application/vnd.ms-excel', 'xlt' => 'application/vnd.ms-excel', 'xlw' => 'application/vnd.ms-excel', 'xof' => 'x-world/x-vrml', 'xpm' => 'image/x-xpixmap', 'xwd' => 'image/x-xwindowdump', 'z' => 'application/x-compress', 'zip' => 'application/zip' );
	$type = strtolower ( $type );
	if (isset ( $types [$type] ))
		header ( 'Content-Type: ' . $types [$type] . '; charset=' . $charset );
}
/**
 * URL重定向
 * @param string $url 重定向的URL地址
 * @param integer $time 重定向的等待时间（秒）
 * @param string $msg 重定向前的提示信息
 * @return void
 */
function Redirect($url, $time = 0, $msg = '') {
	if (empty ( $msg ))
		$msg = "将在{$time}秒之后自动跳转到{$url}！";
	SetContentType ();
	if (! headers_sent ()) {
		if (0 === $time) {
			header ( 'Location: ' . $url );
		} else {
			header ( "refresh:{$time};url={$url}" );
			echo ($msg);
		}
		exit ();
	} else {
		$str = "<meta http-equiv='Refresh' content='{$time};URL={$url}'>";
		if ($time != 0)
			$str .= $msg;
		exit ( $str );
	}
}

/**
 * 快速文件数据读取和保存 针对简单类型数据 字符串、数组
 * @param string $name 缓存名称
 * @param mixed $value 缓存值
 * @param string $path 缓存路径
 * @return mixed
 */
function FileData($name, $value = '', $path = APP_FILE_DATA_PATH) {
	static $_cache = array ();
	if (! is_dir ( $path ))
		$path = APP_FILE_DATA_PATH . $path . '/';
	$filename = $path . $name . '.php';
	if ('' !== $value) {
		if (is_null ( $value )) {
			return false !== strpos ( $name, '*' ) ? array_map ( "unlink", glob ( $filename ) ) : unlink ( $filename );
		} else {
			$dir = dirname ( $filename );
			if (! is_dir ( $dir ))
				mkdir ( $dir, 0755, true );
			$_cache [$name] = $value;
			return file_put_contents ( $filename, StripWhitespace ( "<?php\treturn " . var_export ( $value, true ) . ";?>" ) );
		}
	}
	if (isset ( $_cache [$name] ))
		return $_cache [$name];
	if (is_file ( $filename )) {
		$value = include $filename;
		$_cache [$name] = $value;
	} else {
		$value = false;
	}
	return $value;
}

/**
 * 根据PHP各种类型变量生成唯一标识号
 * @param mixed $mix 变量
 * @return string
 */
function Guid($mix) {
	if (is_object ( $mix ) && function_exists ( 'spl_object_hash' )) {
		return spl_object_hash ( $mix );
	} elseif (is_resource ( $mix )) {
		$mix = get_resource_type ( $mix ) . strval ( $mix );
	} else {
		$mix = serialize ( $mix );
	}
	return md5 ( $mix );
}

/**
 * 获取客户端IP地址
 * @param integer $type 返回类型 0 返回IP地址 1 返回IPV4地址数字
 * @return mixed
 */
function GetIP($type = 0) {
	$type = $type ? 1 : 0;
	static $ip = NULL;
	if ($ip !== NULL)
		return $ip [$type];
	if (isset ( $_SERVER ['HTTP_X_FORWARDED_FOR'] )) {
		$arr = explode ( ',', $_SERVER ['HTTP_X_FORWARDED_FOR'] );
		$pos = array_search ( 'unknown', $arr );
		if (false !== $pos)
			unset ( $arr [$pos] );
		$ip = trim ( $arr [0] );
	} elseif (isset ( $_SERVER ['HTTP_CLIENT_IP'] )) {
		$ip = $_SERVER ['HTTP_CLIENT_IP'];
	} elseif (isset ( $_SERVER ['REMOTE_ADDR'] )) {
		$ip = $_SERVER ['REMOTE_ADDR'];
	}
	$long = sprintf ( "%u", ip2long ( $ip ) );
	$ip = $long ? array ($ip, $long ) : array ('0.0.0.0', 0 );
	return $ip [$type];
}

/**
 * 发送HTTP状态
 * @param integer $code 状态码
 * @return void
 */
function SendHttpStatus($code) {
	static $_status = array (100 => 'Continue', 101 => 'Switching Protocols', 200 => 'OK', 201 => 'Created', 202 => 'Accepted', 203 => 'Non-Authoritative Information', 204 => 'No Content', 205 => 'Reset Content', 206 => 'Partial Content', 300 => 'Multiple Choices', 301 => 'Moved Permanently', 302 => 'Moved Temporarily ', 303 => 'See Other', 304 => 'Not Modified', 305 => 'Use Proxy', 307 => 'Temporary Redirect', 400 => 'Bad Request', 401 => 'Unauthorized', 402 => 'Payment Required', 403 => 'Forbidden', 404 => 'Not Found', 405 => 'Method Not Allowed', 406 => 'Not Acceptable', 407 => 'Proxy Authentication Required', 408 => 'Request Timeout', 409 => 'Conflict', 410 => 'Gone', 411 => 'Length Required', 412 => 'Precondition Failed', 413 => 'Request Entity Too Large', 414 => 'Request-URI Too Long', 415 => 'Unsupported Media Type', 416 => 'Requested Range Not Satisfiable', 417 => 'Expectation Failed', 500 => 'Internal Server Error', 501 => 'Not Implemented', 502 => 'Bad Gateway', 503 => 'Service Unavailable', 504 => 'Gateway Timeout', 505 => 'HTTP Version Not Supported', 509 => 'Bandwidth Limit Exceeded' );
	if (isset ( $_status [$code] )) {
		header ( 'HTTP/1.1 ' . $code . ' ' . $_status [$code] );
		header ( 'Status:' . $code . ' ' . $_status [$code] );
	}
}